(* Copy files to FTP server , Unicode-Version (Delphi 10)

    Dr. J. Rathlev, D-24222 Schwentinental (kontakt(a)rathlev-home.de)

   The contents of this file may be used under the terms of the
   Mozilla Public License ("MPL") or
   GNU Lesser General Public License Version 2 or later (the "LGPL")

   Software distributed under this License is distributed on an "AS IS" basis,
   WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
   the specific language governing rights and limitations under the License.
   *)

program FtpCopy;

uses
  GnuGetText in 'units\GnuGetText.pas',
  LangUtils in 'units\LangUtils.pas',
  Forms,
  Graphics,
  FtpCopyMain in 'FtpCopyMain.pas' {MainForm},
  OpenFilesDlg in 'OpenFilesDlg.pas' {OpenFilesDialog},
  FtpDlg in 'units\FtpDlg.pas' {FtpDialog},
  PwdDlg in 'units\PwdDlg.pas' {PasswordDialog},
  FtpProxyDlg in 'units\FtpProxyDlg.pas' {FtpProxyDialog},
  ShellDirDlg in 'units\ShellDirDlg.pas' {ShellDirDialog},
  TransferStat in 'units\TransferStat.pas' {TransferStatus},
  Textdlg in 'units\Textdlg.pas' {TextEingabe},
  FileErrors in 'units\FileErrors.pas',
  FtpUtils in 'units\FtpUtils.pas',
  FtpCopyCommon in 'FtpCopyCommon.pas';

{$R *.res}

begin
  TP_GlobalIgnoreClass(TFont);
  // Subdirectory in AppData for user configuration files and supported languages
  InitTranslation('','',['delphi10','indy10','units']);

  Application.Initialize;
  Application.CreateForm(TMainForm, MainForm);
  Application.CreateForm(TFtpDialog, FtpDialog);
  Application.CreateForm(TPasswordDialog, PasswordDialog);
  Application.CreateForm(TFtpProxyDialog, FtpProxyDialog);
  Application.CreateForm(TShellDirDialog, ShellDirDialog);
  Application.CreateForm(TOpenFilesDialog, OpenFilesDialog);
  Application.CreateForm(TTransferStatus, TransferStatus);
  Application.CreateForm(TTextEingabe, TextEingabe);
  if MainForm.CheckRemote then Application.Terminate
  else Application.Run;
end.
