(* Delphi Dialog
   Select FTP server from list
   ===========================

    Dr. J. Rathlev, D-24222 Schwentinental (kontakt(a)rathlev-home.de)

   The contents of this file may be used under the terms of the
   Mozilla Public License ("MPL") or
   GNU Lesser General Public License Version 2 or later (the "LGPL")

   Software distributed under this License is distributed on an "AS IS" basis,
   WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
   the specific language governing rights and limitations under the License.

   Vers. 1 - Okt. 2008
   last modified: Feb. 2022
   *)

unit SelectFtpDlg;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, FtpUtils;

type
  TFtpSettings = class (TObject)
    ID          : integer;
    FtpPar      : TFtpParams;
    ConnectionError : boolean;
    constructor Create (NewID : integer);
    end;

  TSelectFtpDialog = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    cbFtpServer: TComboBox;
    Label1: TLabel;
    Label2: TLabel;
    edSubDir: TEdit;
    procedure FormCreate(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
    function Execute (FtpList : TStrings; var FtpID : integer; var SubDir : string) : boolean;
  end;

function SearchForID (FtpList : TStrings; AID : integer) : integer;

var
  SelectFtpDialog: TSelectFtpDialog;

implementation

{$R *.dfm}

uses GnuGetText, FtpDlg;

{ ------------------------------------------------------------------- }
constructor TFtpSettings.Create (NewID : integer);
begin
  inherited Create;
  ID:=NewID;
  FtpPar:=FtpDialog.DefaultValues;
  ConnectionError:=false;
  end;

{ ------------------------------------------------------------------- }
function SearchForID (FtpList : TStrings; AID : integer) : integer;
var
  i : integer;
begin
  Result:=-1;
  with FtpList do for i:=0 to Count-1 do with (Objects[i] as TFtpSettings) do
      if ID=AID then begin
    Result:=i; Break;
    end;
  end;

{ ------------------------------------------------------------------- }
procedure TSelectFtpDialog.FormCreate(Sender: TObject);
begin
  TranslateComponent (self);
  end;

function TSelectFtpDialog.Execute (FtpList : TStrings; var FtpID : integer; var SubDir : string) : boolean;
begin
  with cbFtpServer do begin
    Items:=FtpList;
    ItemIndex:=SearchForID(FtpList,FtpID);
    end;
  edSubDir.Text:=SubDir;
  if ShowModal=mrOK then begin
    FtpID:=(FtpList.Objects[cbFtpServer.ItemIndex] as TFtpSettings).ID;
    SubDir:=edSubDir.Text;
    Result:=true;
    end
  else Result:=false;
  end;

end.
