program VersionCopy;

uses
  GnuGetText in 'units\GnuGetText.pas',
  LangUtils in 'units\LangUtils.pas',
  Forms,
  Graphics,
  VersionCopyMain in 'VersionCopyMain.pas' {MainForm},
  FtpProxyDlg in 'units\FtpProxyDlg.pas' {FtpProxyDialog},
  FtpDlg in 'units\FtpDlg.pas' {FtpDialog},
  ShellDirDlg in 'units\ShellDirDlg.pas' {ShellDirDialog},
  PwdDlg in 'units\PwdDlg.pas' {PasswordDialog},
  TransferStat in 'units\TransferStat.pas' {TransferStatus},
  SelectFtpDlg in 'SelectFtpDlg.pas' {SelectFtpDialog},
  ShowMemo in 'units\ShowMemo.pas' {ShowtextDialog},
  FtpConsts in 'units\FtpConsts.pas';

{$R *.res}

begin
  TP_GlobalIgnoreClass(TFont);
  // Subdirectory in AppData for user configuration files and supported languages
  InitTranslation('','',['delphi10','indy10','units']);

  Application.Initialize;
  Application.CreateForm(TMainForm, MainForm);
  Application.CreateForm(TFtpProxyDialog, FtpProxyDialog);
  Application.CreateForm(TFtpDialog, FtpDialog);
  Application.CreateForm(TShellDirDialog, ShellDirDialog);
  Application.CreateForm(TPasswordDialog, PasswordDialog);
  Application.CreateForm(TTransferStatus, TransferStatus);
  Application.CreateForm(TSelectFtpDialog, SelectFtpDialog);
  Application.CreateForm(TShowtextDialog, ShowtextDialog);
  if MainForm.CheckRemote then Application.Terminate
  else Application.Run;
end.
