(* Read password from console input

   sample from https://gist.github.com/anonymous/570659
   several bug fixes applied

    Dr. J. Rathlev, D-24222 Schwentinental (kontakt(a)rathlev-home.de)

   The contents of this file may be used under the terms of the
   Mozilla Public License ("MPL") or
   GNU Lesser General Public License Version 2 or later (the "LGPL")

   Software distributed under this License is distributed on an "AS IS" basis,
   WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
   the specific language governing rights and limitations under the License.


  *)

unit ConsolePwd;

interface

function ConsoleGetPassword (const caption: string) : string;

implementation

uses
  System.SysUtils, WinApi.Windows;

var
  ConsoleInpHandle,ConsoleOutHandle : THandle;
  ConsoleScreenBuffer : TConsoleScreenBufferInfo;

function EnableEcho(const ShowText: Boolean): Cardinal;
begin
  GetConsoleMode(ConsoleOutHandle, Result);
  if ShowText then SetConsoleMode(ConsoleOutHandle, Result or ENABLE_ECHO_INPUT)
  else SetConsoleMode(ConsoleOutHandle, Result and not ENABLE_ECHO_INPUT);
  end;

function GetKey : Char;
var
  OldMode: Cardinal;
  bufSize: Cardinal;
begin
  GetConsoleMode(ConsoleInpHandle,OldMode);
  SetConsoleMode(ConsoleInpHandle,OldMode and not (ENABLE_LINE_INPUT or ENABLE_ECHO_INPUT));
  ReadConsole(ConsoleInpHandle,@Result,1,bufSize,nil);
  SetConsoleMode(ConsoleInpHandle,OldMode);
  end;

procedure MoveCursorLeft (pos: TCoord);
begin
  with pos do if x>0 then dec(X);
  SetConsoleCursorPosition(ConsoleOutHandle,pos);
  end;

function GetPassword(const caption: string; const MaskChar: Char = '*') : String;
var
  c: Char;
begin
  Write(caption);
  EnableEcho(False);
  while True do begin
    c := GetKey;
    case c of
    #13: Break;
    #8:  begin
         GetConsoleScreenBufferInfo(ConsoleOutHandle,ConsoleScreenBuffer);
         if Length(Result) > 0 then begin
           Delete(Result, Length(Result), 1);
           with ConsoleScreenBuffer do begin
             MoveCursorLeft(dwCursorPosition);
             Write(' ');
             MoveCursorLeft(dwCursorPosition);
             end;
           end;
         end;
    else begin
        Result:=Result+c;
        Write(MaskChar);
        end;
      end;
    end;
  EnableEcho(True);
  end;

function ConsoleGetPassword (const caption: string) : string;
// main
begin
  ConsoleInpHandle:=GetStdHandle(STD_INPUT_HANDLE);
  ConsoleOutHandle:=GetStdHandle(STD_OUTPUT_HANDLE);
  Result:=GetPassword(caption);
  end;

end.
