(* Resource strings for FTP connections

    Dr. J. Rathlev, D-24222 Schwentinental (kontakt(a)rathlev-home.de)

   The contents of this file may be used under the terms of the
   Mozilla Public License ("MPL") or
   GNU Lesser General Public License Version 2 or later (the "LGPL")

   Software distributed under this License is distributed on an "AS IS" basis,
   WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
   the specific language governing rights and limitations under the License.

   Vers. 1.0 - June 2016
   last updated: Feb. 2022
   *)

unit FtpConsts;

interface

resourcestring
// Strings for FTP connections
  rsFtpConn = 'FTP connection';
  rsTryConnect = 'Trying to connect to FTP server';
  rsConnected = 'Connection to FTP server established';
  rsConnectErr = 'Connection to FTP server failed';
  rsConnectTo = 'Connection to FTP server: %s:%u';
  rsFtpHint = 'Connection to FTP server: %s:%u'+sLineBreak+'for user: %s'+sLineBreak+'requires a password!';
  rsProxyHint = 'Connection to FTP proxy server: %s:%u'+sLineBreak+'for user: %s'+sLineBreak+'requires a password!';
  rsNoConnect = 'FTP connection lost!';
  rsTryReconnect = 'Trying to reconnect';
  rsFtpWelcome = 'FTP welcome message:';
  rsFtpStatus = 'FTP status query:';
  rsFtpFeat = 'Supported features: ';
  rsFtpRespCode = 'Response code: ';
  rsFtpResponse = 'Last FTP response: ';
  rsIndyError = 'Reported error: ';
  rsUnexpected = 'Unexpected response to command: ';
  rsFtpTimeOut = 'Timeout on command: ';
  rsFtpBase = 'FTP root directory: "%s"';
  rsFtpDir  = 'Current FTP directory: "%s"';

// Certicate info
  rsCertVersion = 'Version';
  rsSerialNr = 'Serial number';
  rsIssuer = 'Issuer';
  rsValidUntil = 'Valid until';
  rsFingerprint = 'Fingerprint';
  rsVerCertError = 'Error verifying server certificate';

implementation

end.
