(* Delphi Dialog
   Dialog: eine oder mehrere Dateien auswhlen
   ============================================

    Dr. J. Rathlev, D-24222 Schwentinental (kontakt(a)rathlev-home.de)

   The contents of this file may be used under the terms of the
   Mozilla Public License ("MPL") or
   GNU Lesser General Public License Version 2 or later (the "LGPL")

   Software distributed under this License is distributed on an "AS IS" basis,
   WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
   the specific language governing rights and limitations under the License.

   Oct. 2008
   last modified: Nov. 2021
   *)

unit OpenFilesDlg;

interface

uses Winapi.Windows, System.SysUtils, System.Classes, Vcl.Graphics, Vcl.Forms,
  Vcl.Controls, Vcl.StdCtrls, Vcl.Buttons, Vcl.ExtCtrls, Vcl.FileCtrl;

type
  TOpenFilesDialog = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    lePath: TLabeledEdit;
    FileListBox: TFileListBox;
    FilterComboBox: TFilterComboBox;
    Label1: TLabel;
    btnAll: TBitBtn;
    btnNone: TBitBtn;
    procedure btnAllClick(Sender: TObject);
    procedure btnNoneClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    function Execute (const ATitle,APath,AFilter : string; FList : TStringList) : boolean;
  end;

var
  OpenFilesDialog: TOpenFilesDialog;

implementation

{$R *.dfm}

uses GnuGetText;

procedure TOpenFilesDialog.FormCreate(Sender: TObject);
begin
  TranslateComponent (self,'dialogs');
  end;

procedure TOpenFilesDialog.btnAllClick(Sender: TObject);
begin
  FileListBox.SelectAll;
  end;

procedure TOpenFilesDialog.btnNoneClick(Sender: TObject);
begin
  FileListBox.ClearSelection;
  end;

function TOpenFilesDialog.Execute (const ATitle,APath,AFilter : string; FList : TStringList) : boolean;
var
  i : integer;
begin
  if length(ATitle)>0 then Caption:=ATitle;
  lePath.Text:=APath;
  FileListBox.Directory:=APath;
  FilterComboBox.Filter:=AFilter;
  if ShowModal=mrOK then with FileListBox do begin
    FList.Clear;
    for i:=0 to Items.Count-1 do if Selected[i] then FList.Add(Items[i]);
    Result:=true;
    end
  else Result:=false;
  end;

end.
