(* Delphi conssole application
   Prepare a key for saving encrypted passwords
   ============================================

    Dr. J. Rathlev, D-24222 Schwentinental (kontakt(a)rathlev-home.de)

   The contents of this file may be used under the terms of the
   Mozilla Public License ("MPL") or
   GNU Lesser General Public License Version 2 or later (the "LGPL")

   Software distributed under this License is distributed on an "AS IS" basis,
   WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
   the specific language governing rights and limitations under the License.

   Vers. 1 - Aug. 2020
*)

program EncPwd;

{$APPTYPE CONSOLE}

{$R *.res}

uses
  System.SysUtils;

type
  TByteArray = array of byte;

const
  Key : byte = $93;

  procedure SetByte (ba : TByteArray; ndx : integer; b : byte);
  begin
    if ndx and 1 = 0 then begin // gerade
      ba[2*ndx]:=b and $F + random(16)*$10;
      ba[2*ndx+1]:=(b and $F0) div $10 + random(16)*$10;
      end
    else begin // ungerade
      ba[2*ndx]:=(b and $F0) + random(16);
      ba[2*ndx+1]:=(b and $F)*$10 + random(16);
      end;
    end;

  function EncodeString (s : AnsiString) : AnsiString;
  var
    ba  : TByteArray;
    sn  : byte;
    n,i : integer;
  begin
  sn:=length(s);
    randomize;
    n:=2*(sn+1)+5+random(5);
    SetLength (ba,n);
    SetByte (ba,0,sn);
    for i:=1 to sn do SetByte (ba,i,ord(s[i]));
    for i:=2*(sn+1) to n-1 do ba[i]:=random(256);
    for i:=0 to n-1 do ba[i]:=ba[i] xor Key;
    Result:='';
    for i:=0 to n-1 do Result:=Result+IntToHex(ba[i],2);
    end;

var
  s : AnsiString;
begin
  if ParamCount>0 then begin
    s:=ParamStr(1);
    writeln(s,' => ',EncodeString(s));
    end
  else writeln('Usage: encpwd <keystring>');
{$ifdef DEBUG}
  write('Strike enter key to continue ...');
  readln;
{$endif}

end.
