; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!

[Setup]
PrivilegesRequired=poweruser
AppName=GgtUpdate
AppVerName=Gnu Gettext Update
AppPublisher=J. Rathlev
AppPublisherURL=http://www.rathlev-home.de/?tools/othertools.html
AppSupportURL=http://www.rathlev-home.de/?tools/othertools.html
AppUpdatesURL=http://www.rathlev-home.de/?tools/othertools.html
DefaultDirName={pf}\dxgettext
DefaultGroupName=GNU Gettext for Delphi and C++ Builder
Uninstallable=no
AllowNoIcons=yes
LicenseFile=license.txt
OutputDir=..\update-jr
OutputBaseFilename=dxgettext-update
WizardImageFile=..\..\WizImage-JR.bmp
WizardSmallImageFile=..\..\WizSmallImage-JR.bmp
Compression=lzma
SolidCompression=yes

[Languages]
Name: "en"; MessagesFile: "compiler:Default.isl"
Name: "de"; MessagesFile: "compiler:Languages\German.isl"

[CustomMessages]
en.FileAssoc=File associations:
de.FileAssoc=Dateizuordnungen:
en.DescContext=Add "dxgettext" functions in context menus
de.DescContext=Fge "dxgettext"-Funktionen zu den Kontext-Mens hinzu
en.CompileContext=&Compile to mo file ..
de.CompileContext=in MO-Datei &bersetzen ..
en.MergeContext=&Merge with template ..
de.MergeContext=mit Schablone &zusammenfhren ..
en.DecompContext=&Decompile to po file ..
de.DecompContext=in PO-Datei &zurckfhren ..
en.EmbedContext=Embed &translations ..
de.EmbedContext=&bersetzungen integrieren ..
en.ExtractContext=&Extract strings ..
de.ExtractContext=Strings &extrahieren ..
en.TemplateContext=Extract &translations to template ..
de.TemplateContext=&bersetzungs-Schablone erstellen ..

[Tasks]
Name: "fileassoc"; Description: "{cm:DescContext}"; GroupDescription: "{cm:FileAssoc}"; Flags: checkedonce

[Registry]
Root: HKCR; Subkey: "{code:GetKey|PO}\Shell\Merge template"; ValueType: string; ValueName: ""; ValueData: "{cm:MergeContext}"; Tasks: fileassoc; Flags: deletevalue
Root: HKCR; Subkey: "{code:GetKey|PO}\shell\Compile to mo file"; ValueType: string; ValueName: ""; ValueData: "{cm:CompileContext}"; Tasks: fileassoc; Flags: deletevalue
Root: HKCR; Subkey: "{code:GetKey|MO}\shell\Decompile to po file"; ValueType: string; ValueName: ""; ValueData: "{cm:DeCompContext}"; Tasks: fileassoc; Flags: deletevalue
Root: HKCR; Subkey: "{code:GetKey|EXE}\shell\Embed translations"; ValueType: string; ValueName: ""; ValueData: "{cm:EmbedContext}"; Tasks: fileassoc; Flags: deletevalue
Root: HKCR; Subkey: "{code:GetKey|EXE}\shell\Extract strings"; ValueType: string; ValueName: ""; ValueData: "{cm:ExtractContext}"; Tasks: fileassoc; Flags: deletevalue
Root: HKCR; Subkey: "{code:GetKey|DLL}\shell\Embed translations"; ValueType: string; ValueName: ""; ValueData: "{cm:EmbedContext}"; Tasks: fileassoc; Flags: deletevalue
Root: HKCR; Subkey: "{code:GetKey|DLL}\shell\Extract strings"; ValueType: string; ValueName: ""; ValueData: "{cm:ExtractContext}"; Tasks: fileassoc; Flags: deletevalue
Root: HKCR; Subkey: "{code:GetKey|OCX}\shell\Embed translations"; ValueType: string; ValueName: ""; ValueData: "{cm:EmbedContext}"; Tasks: fileassoc; Flags: deletevalue
Root: HKCR; Subkey: "{code:GetKey|OCX}\shell\Extract strings"; ValueType: string; ValueName: ""; ValueData: "{cm:ExtractContext}"; Tasks: fileassoc; Flags: deletevalue
Root: HKCR; Subkey: "{code:GetKey|BPL}\shell\Embed translations"; ValueType: string; ValueName: ""; ValueData: "{cm:EmbedContext}"; Tasks: fileassoc; Flags: deletevalue
Root: HKCR; Subkey: "{code:GetKey|BPL}\shell\Extract strings"; ValueType: string; ValueName: ""; ValueData: "{cm:ExtractContext}"; Tasks: fileassoc; Flags: deletevalue
Root: HKCR; Subkey: "Folder\shell\Extract translations to template"; ValueType: string; ValueName: ""; ValueData: "{cm:TemplateContext}"; Tasks: fileassoc; Flags: deletevalue

[Files]
Source: "\Delphi7\bin\dxgt\GgtTranslate.exe"; DestDir: "{app}"; Flags: ignoreversion
Source: "\Delphi7\bin\dxgt\ggdxgettext.exe"; DestDir: "{app}"; Flags: ignoreversion
Source: "\Delphi7\bin\dxgt\ggmerge.exe"; DestDir: "{app}"; Flags: ignoreversion
; NOTE: Don't use "Flags: ignoreversion" on any shared system files

[Code]
function GetKey (Ext : String) : String;
var
  App : String;
begin
  if not RegQueryStringValue(HKEY_CLASSES_ROOT, '.'+Ext, '', App) then begin
    App:=Ext+' file';
    RegWriteStringValue(HKEY_CLASSES_ROOT, '.'+Ext, '', App);
    end;
  Result:=App;
end;
