; BINARY TO GRAY CODE
; *******************
; DIGITAL COMPUTER CONTROLS,INC.
; 116-0041A
;
; COMPUTES THE GRAY CODE OF A 16 BIT BINARY WORD
; INPUT:        BINARY WORD IN AC0
; OUTPUT:       GRAY CODE WORD IN AC0
; CALLING SEQUENCE:
;       JSR     .BGRY
;       RETURN
; METHOD:       GRAY = BIN .XOR. (BIN/2)
; UNCHANGED:    AC1, AC2
; DESTROYED:    AC0, AC3, CARRY

	.REL	0
	.TITL	.BGRY

.BGRY:  STA 1,.UB01     ; *SAVE AC1
        STA 3,.UB03     ; SAVE RETURN
        MOVZR 0,1       ; BIN/2
        MOV 1,3         ; EXCLUSIVE OR (SEE .XOR )
        ANDZL 0,3
        ADD 1,0
        SUB 3,0
        LDA 1,.UB01     ; *RESTORE AC1
        JMP @.UB03      ; RETURN

.UB01:  0               ; *SAVE AC1
.UB03:  0               ; SAVE RETURN

	.END		;BINARY TO GRAY CONV.
