
; DOUBLE PRECISION ADDITION
;*********************************
; DIGITAL COMPUTER CONTROLS,INC.
; 116-0020A-L
;
; COMPUTES THE SUM OF TWO DOUBLE PRECISION TWO'S
;       COMPLEMENT INTEGERS
; INPUT:        D1 IN AC0, AC1 (HIGH AND LOW)
;               ADDRESS OF D2 IN WORD AFTER JSR
; OUTPUT:       D1+D2 IN AC0, AC1 (HIGH AND LOW)
; CALLING SEQUENCE:
;       JSR     .DADD
;       ADDRESS OF SECOND OPERAND
;       RETURN
; CAUTION:      NO CHECK IS MADE FOR OVERFLOW
; UNCHANGED:    AC2
; DESTROYED:    AC0, AC1, AC3, CARRY
	.REL	0
	.TITL	.DADD
.DADD:  STA 3,.BD03     ; SAVE RETURN
        ISZ .BD03       ; BUMP PAST ADDRESS CONSTANT
        STA 2,.BD02     ; *SAVE AC2
        LDA 3,0,3       ; ADDRESS OF D2
        LDA 2,0,3       ; HIGH ORDER OF D2
        LDA 3,1,3       ; LOW ORDER OF D2
        ADDZ 3,1,SZC    ; LOW ORDER ADD
        INC 0,0         ; CARRY TO HIGH ORDER
        ADD 2,0         ; HIGH ORDER ADD
        LDA 2,.BD02     ; *RESTORE AC2
        JMP @.BD03      ; AND RETURN
.BD02:  0               ; *SAVE AC2
.BD03:  0               ; SAVE RETURN
	.END		;DBL.PREC.INTEG.ADD
