
; DOUBLE PRECISION -- BCD TO BINARY
; *********************************
; DIGITAL COMPUTER CONTROLS,INC.
; 116-0036A
;
; CONVERT A DOUBLE PRECISION NUMBER
; IN BCD TO BINARY
; INPUT:        A DOUBLE PRECISION BCD INTEGER IN
;               AC0, AC1 (HIGH, LOW) OF MAXIMUM VALUE
;               99999999 DECIMAL
; OUTPUT:       BINARY EQUIVALENT OF BCD INPUT IN AC0,
;               AC1 (HIGH, LOW)
; CALLING SEQUENCE:
;       JSR     .DBCB
;       RETURN
; ERROR CONDITION:      IF A DIGIT >9 IS ENCOUNTERED IN
;               THE INPUT, CARRY WILL BE SET
;               AND AC0 WILL CONTAIN THE BAD DIGIT
; DESTROYED:    AC0, AC1, AC3, CARRY
; UNCHANGED:    AC2
	.REL	0
	.TITL	.DBCB
.DBCB:  STA 3,.FA03     ; SAVE RETURN
        STA 0,.FA12
        STA 1,.FA12+1   ; SAVE INPUT
        SUB 3,3
        STA 3,.FA10
        STA 3,.FA10+1   ; CLEAR RESULT WORDS
        LDA 3,.FA20     ; LOOP 8 TIMES
        STA 3,.FA11
.FA99:  JSR .FA50       ; GET A DIGIT
        JMP .FA98       ; ERROR IN DIGIT, CARRY IS SET
        JSR .FA51       ; MULTIPLY BY 10 AND ADD
        DSZ .FA11       ; LOOP FOR 8 DIGITS
        JMP .FA99
        LDA 0,.FA10
        LDA 1,.FA10+1
.FA98:  JMP @.FA03      ; RETURN
; RETURN NEXT BCD DIGIT
; RIGHT ADJUSTED IN AC0
.FA50:  LDA 1,.FA12     ; GET INPUT
        LDA 2,.FA12+1
        LDA 0,.FA21     ; COUNT FOR 4 LEFT SHIFTS
        STA 0,.FA13
        SUB 0,0
        MOVZL 2,2
        MOVL 1,1
        MOVL 0,0
        DSZ .FA13
        JMP .-4
        STA 1,.FA12     ; SAVE SHIFTED INPUT
        STA 2,.FA12+1
        LDA 1,.FA22     ; TEST CONSTANT (10 DECIMAL)
        ADCO 0,1,SZC
        JMP 0,3         ; ERROR: >9, CARRY SET
        JMP 1,3         ; SUCCESS: <= 9
; MULTIPLY BY 10 AND ADD AC0
.FA51:  LDA 1,.FA10     ; GET CURRENT SUM
        LDA 2,.FA10+1
        MOVZL 2,2
        MOVL 1,1
        MOVZL 2,2
        MOVL 1,1        ; *4
        STA 3,.FA14     ; SAVE RETURN
        LDA 3,.FA10+1   ; LOW ORDER
        ADDZ 3,2,SZC
        INC 1,1
        LDA 3,.FA10
        ADD 3,1         ; *(4+1)
        MOVZL 2,2
        MOVL 1,1        ; 2*(4+1)
        ADDZ 0,2,SZC
        INCZ 1,1
        STA 1,.FA10     ; SAVE RESULTS
        STA 2,.FA10+1
        JMP @.FA14      ; RETURN
.FA03:  0               ; SAVE RETURN
.FA10:  .BLK 2          ; RESULT WORDS
.FA11:  0               ; MAIN LOOP COUNT WORD
.FA12:  .BLK 2          ; INPUT
.FA13:  0               ; DIGIT LOOP COUNT WORD
.FA14:  0               ; RETURN FROM MULTIPLY BY 10
.FA20:  10              ; MAIN COUNT OF 8
.FA21:  4               ; DIGIT SHIFT OF 4
.FA22:  12              ; ERROR TEST (DECIMAL 10)
	.END		;DBL. BCD TO BIN.
