
; DOUBLE PRECISION--BINARY TO BCD
; *******************************
; DIGITAL COMPUTER CONTROLS,INC.
; 116-0037A
;
; CONVERT A DOUBLE PRECISION BINARY NUMBER
;       TO A DOUBLE PRECISION BCD NUMBER
; INPUT:        AN UNSIGNED DOUBLE PRECISION BINARY
;               NUMBER IN AC0, AC1 (HIGH, LOW)
; OUTPUT:       THE BCD EQUIVALENT IN AC0, AC1 (HIGH,
;               LOW)
; CALLING SEQUENCE:
;       JSR     .DBBC
;       RETURN
; ERROR CONDITION:      IF AC0, AC1 CONTAIN A NUMBER
;               GREATER THAN 99999999, NO CONVERSION
;               WILL TAKE PLACE AND CARRY WILL BE SET
; UNCHANGED:    AC2
; DESTROYED:    AC0, AC1, AC3, CARRY
; REQUIRES:     .DIVU (UNSIGNED DIVIDE)
	.REL	0
	.TITL	.DBBC
	.EXTN	.DIVU
.DBBC:  STA 3,.FB03     ; SAVE RETURN
        LDA 2,.FB20     ; GET 100,000,000
        LDA 3,.FB20+1
        ADCZ# 0,2,SZC
        JMP .FB99       ; INPUT OK
        SUBO 0,2,SNR
        ADCO 1,3,SZC
        JMP @.FB03      ; ERROR CARRY IS SET
.FB99:  LDA 2,.FB21
        JSR @.FB31      ; DIVIDE BY 10,000
        STA 0,.FB10     ; SAVE REMAINDER
        JSR .FB50       ; CONVERT HIGH ORDER
        STA 0,.FB11     ; SAVE RESULTS HIGH
        LDA 1,.FB10
        JSR .FB50       ; CONVERT LOW ORDER
        MOVZ 0,1
        LDA 0,.FB11     ; RESULTS TO AC0, AC1
        JMP @.FB03
; CONVERT BINARY IN AC1 TO BCD IN AC0
.FB50:  LDA 2,.FB30     ; ADDRESS OF POWER OF TEN TABLE
        STA 2,.FB12     ; SAVE IT
        SUB 0,0         ; CLEAR AC0
.FB52:  LDA 2,@.FB12    ; GET POWER OF TEN
        ISZ .FB12       ; BUMP TO NEXT ENTRY
        MOVZL 0,0
        MOVZL 0,0
        MOVZL 0,0
        MOVZL 0,0
.FB51:  SUBZ 2,1,SZC    ; DOES POWER OF 10 GO IN?
        INC 0,0,SKP     ; YES, BUMP BDC OUTPUT
        ADD 2,1,SKP     ; NO, RESTORE AC1
        JMP .FB51       ; SUBTRACT AGAIN
        MOVZR 2,2,SZR   ; DONE IF 10**0
        JMP .FB52       ; NO, CONTINUE
        JMP 0,3         ; YES, RETURN
.FB03:  0               ; SAVE RETURN
        .RDX 10
.FB05:  1000            ; 10**3
        100             ; 10**2
        10              ; 10**1
        1               ; 10**0
        .RDX 8
.FB10:  0               ; SAVE REMAINDER
.FB11:  0               ; SAVE HIGH ORDER RESULTS
.FB12:  0               ; POINTER TO CURRENT POWER OF
                        ; TEN
.FB20:  2765            ; 10**9 (ERROR TEST)
        160400
.FB21:  23420           ; 10**4
.FB30:  .FB05           ; ADDRESS OF POWER OF TEN TABLE
.FB31:  .DIVU           ; UNSIGNED DIVIDE REQUIRED
	.END		;DBL. BIN. TO BCD.
