
; DOUBLE PRECISION-- BINARY TO ASCII DECIMAL
; ******************************************
; DIGITAL COMPUTER CONTROLS,INC.
; 116-0039A
;
; BINARY TO DECIMAL ASCII CONVERT
; CONVERTS A DOUBLE PRECISION, TWO'S COMPLEMENT NUMBER
; TO AN ASCII DECIMAL CHARACTER STRING
; INPUT:        D IN AC1, AC2 (HIGH, LOW)
; OUTPUT:       ASCII CHARACTER STRING, TERMINATED BY A
;               NULL WORD.
;               CHARACTERS PASSED RIGHT ADJUSTED,
;               BIT 8 = 0, IN AC0 TO USER
;               ROUTINE WHOSE ADDRESS MUST BE
;               STORED IN LOCATION 41 OF PAGE 0
;               STRING OF FORM:
;                       +NNNNNNNNNN(NULL)
;               OR      -NNNNNNNNNN(NULL)
; CALLING SEQUENCE
;       JSR     .DBD
;       RETURN
; DESTROYED:    AC1, AC2, AC3, CARRY
; UNCHANGED:    AC0
	.REL	0
	.TITL	.DBD
.DBD:   STA 3,.FD03     ; SAVE RETURN
        STA 0,.FD00     ; SAVE AC0
        LDA 0,.FD30     ; POINT TO HIGH ORDER POWER IN
                        ; TABLE
        STA 0,.FD12
        LDA 0,.FD20     ; ASSUME "+"
        MOVL# 1,1,SNC
        JMP .FD99       ; YES, WAS POSITIVE
        NEG 2,2,SZR     ; NO, NEGATIVE
        COM 1,1,SKP
        NEG 1,1
        LDA 0,.FD21     ; GET "-"
.FD99:  STA 1,.FD10     ; SAVE ABS(NUMBER)
        STA 2,.FD10+1
        JSR @.FD40      ; PUT OUT SIGN OR DIGIT
	LDA 1,.FD10	; RESTORE ABS(NUMBER)
	LDA 2,.FD10+1
        LDA 0,.FD22     ; GET OCTAL 57
        STA 0,.FD11     ; COUNT IT UP IN STORAGE
        LDA 3,.FD12     ; CURRENT POINTER TO POWER OF
                        ; 10 TABLE
.FD98:  LDA 0,1,3       ; LOW ORDER WORD
        MOV 0,0,SNR     ; TEST FOR END OF TABLE
        JMP .FD97       ; DONE
        SUBZ 0,2
        LDA 0,0,3       ; HIGH ORDER WORD
        MOV 0,0,SNC
        ADC 0,1,SKP
        SUB 0,1
        ISZ .FD11       ; COUNT UP DIGIT
        MOVL# 1,1,SNC   ; TEST FOR <0
        JMP .FD98       ; KEEP SUBTRACTING
        LDA 0,1,3       ; RESTORE POSITIVE VALUE
        ADDZ 0,2,SZC
        INC 1,1
        LDA 0,0,3
        ADD 0,1
        INC 3,3         ; BUMP AC3 TO NEXT TABLE ENTRY
        INC 3,3
        STA 3,.FD12
        LDA 0,.FD11     ; GET DIGIT
        JMP .FD99       ; PUT IT OUT
.FD97:  JSR @.FD40      ; PUT OUT NULL
        LDA 0,.FD00     ; RESTORE AC0
        JMP @.FD03      ; RETURN
.FD00:  0               ; SAVE AC0
.FD03:  0               ; SAVE RETURN
.FD05:  35632           ; 10**9
        145000
        2765            ; 10**8
        160400
        230             ; 10**7
        113200
        17              ; 10**6
        41100
        1               ; 10**5
        103240
        .RDX 10
        0               ; 10**4
        10000
        0               ; 10**3
        1000
        0               ; 10**2
        100
        0               ; 10**1
        10
        0               ; 10**0
        1
.FD30:  .FD05   ; POINTER TO CONVERSION TABLE
        0       ; END OF TABLE INDICATION
        .RDX 8
.FD10:  .BLK 2          ; SAVE CURRENT DOUBLE WORD
.FD11:  0               ; COUNT UP DIGIT WORD
.FD12:  0               ; POINTER TO POWER OF TEN ENTRY
.FD20:  "+              ; ASCII "+"
.FD21:  "-              ; ASCII "-"
.FD22:  57              ; ASCII "0" -1
.FD40=41                ; PAGE 0 PUT CHARACTER ADDRESS
	.END		;DBL.BIN. TO DEC.
