
; DOUBLE PRECISION--ASCII DECIMAL TO BINARY
; *****************************************
; DIGITAL COMPUTER CONTROLS
; 116-0038A
;
; CONVERT AN ASCII CHARACTER STRING TO A DOUBLE
;       PRECISION BINARY NUMBER
;
; INPUT:        CALLS A GET CHARACTER ROUTINE WHOSE
;               ADDRESS MUST BE STORED IN LOCATION
;               40 OF PAGE 0.
;               CHARACTERS MUST BE RETURNED
;               RIGHT ADJUSTED IN AC0 WITH BIT 8 = 0.
;               + IS OPTIONAL FOR POSITIVE NUMBERS
;               - MUST BE GIVEN FOR NEGATIVE NUMBERS
;               INPUT OF FORM:
;                       SDD...DD(BREAK)
;               S IS THE SIGN (IF GIVEN), D IS A
;               DECIAML DIGIT
;               THE BREAK CHARACTER IS ANY CHARACTER
;               OTHER THAN A DECIMAL DIGIT
; OUTPUT:       AC0 CONTAINS THE BREAK CHARACTER
;               AC1, AC2 CONTAIN THE BINARY RESULTS
;               OF THE CONVERSION
; CALLING SEQUENCE:
;       JSR     .DDB
;       RETURN
; IF AN INDICATION IS DESIRED TO SIGNAL CHARACTERS
; ARE REQUESTED, CALLING SEQUENCE IS:
;       JSR     .DDBI
;       RETURN
; AN ASCII "D" FOLLOWED BY A NULL WORD
; WILL BE TRANSMITTED VIA ACO TO A PUT
; CHARACTER ROUTINE WHOSE ADDRESS MUST
; BE IN LOCATION 41 OF PAGE 0
; CAUTION:      THE ABSOLUTE VALUE OF THE RESULT
;               IS N MOD 2**31.
; DESTROYED:    ALL ACS AND CARRY
	.REL	0
	.TITL	.DDBI
.DDBI:  STA 3,.FC03     ; SAVE RETURN
        LDA 0,.FC20     ; SEND "D"
        JSR @.FC41
        SUB 0,0
        JSR @.FC41      ; SEND NULL
        JMP .+2
.DDB:   STA 3,.FC03     ; SAVE RETURN
        SUB 0,0
        STA 0,.FC10     ; CLEAR SIGN WORD
        STA 0,.FC11     ; CLEAR RESULT WORDS
        STA 0,.FC11+1
        JSR @.FC40      ; GET A CHARACTER
        LDA 1,.FC21     ; TEST FOR "+"
        SUB 0,1,SNR
        JMP .FC99       ; YES
        LDA 1,.FC22     ; TEST FOR "-"
        SUB 0,1,SZR
        JMP .FC98       ; NEITHER
        ISZ .FC10       ; SET SIGN FLAG TO 1 FOR MINUS
.FC99:  JSR @.FC40      ; GET A DIGIT
.FC98:  LDA 1,.FC23     ; TEST ASCII "0"
        LDA 2,.FC24     ; ASCII "9"
        ADCZ# 2,0,SNC   ; TEST FOR A DIGIT
        ADCZ# 0,1,SZC
        JMP .FC97       ; NOT A DIGIT - THEREFORE A
                        ; BREAK
        SUB 1,0         ; REDUCE TO 0-9 RANGE
        LDA 1,.FC11     ; GET SUM WORDS
        LDA 2,.FC11+1
        MOVZL 2,2       ; SUM*4
        MOVL 1,1
        MOVZL 2,2
        MOVL 1,1
        LDA 3,.FC11+1
        ADDZ 3,2,SZC
        INC 1,1
        LDA 3,.FC11
        ADD 3,1         ; SUM*(4+1)
        MOVZL 2,2
        MOVL 1,1        ; 2*SUM*(4+1)
        ADDZ 0,2,SZC    ; SUM*10+AC0
        INC 1,1
        STA 1,.FC11
        STA 2,.FC11+1   ; STORE RESULTS
        JMP .FC99       ; GET NEXT DIGIT
.FC97:  LDA 1,.FC11     ; GET RESULTS
        LDA 2,.FC11+1
        MOVZL 1,1
        MOVZR 1,1       ; SET SIGN +
        DSZ .FC10       ; TEST SIGN OF RESULT
        JMP @.FC03      ; POSITIVE, RETURN
        NEG 2,2,SZR     ; NEGATIVE
        COM 1,1,SKP
        NEG 1,1
        JMP @.FC03      ; RETURN
        
.FC03:  0               ; SAVE RETURN
.FC10:  0               ; SIGN OF RESULT WORD
.FC11:  .BLK 2          ; RESULT WORDS
.FC20:  "D              ; SEND "D" FOR INDICATION
.FC21:  "+              ; ASCII "+"
.FC22:  "-              ; ASCII "-"
.FC23:  "0              ; ASCII "0"
.FC24:  "9              ; ASCII "9"
.FC40=40                ; PAGE 0 GET CHARACTER ADDRESS
.FC41=41                ; PAGE 0 PUT CHARACTER ADDRESS
	.END		;DBL.DEC. TO BIN.
