
; DOUBLE PRECISION NEGATE
; ***********************
; DIGITAL COMPUTER CONTROLS,INC.
; 116-0024A
;
; COMPUTES -D WHERE D IS A DOUBLE PRECISION TWO'S
;       COMPLEMENT INTEGER
; INPUT:        D IN AC0, AC1 (HIGH ORDER, LOW ORDER)
; OUTPUT:       -D IN AC0, AC1
; CALLING SEQUENCE:
;       JSR     .DNEG
;       RETURN
; CAUTION:      THE NEGATIVE OF -2**31 CANNOT
;               BE REPRESENTED AND IS RETURNED UNCHANGED
; DESTROYED:    AC0, AC1, AC3, CARRY
; UNCHANGED:    AC2
	.REL	0
	.TITL	.DNEG
.DNEG:  NEG 1,1,SZR     ; LOW ORDER NEGATE
        COM 0,0,SKP     ; IF AC1 NON-ZERO
                        ; AC0 IS A ONE'S COMPLEMENT
        NEG 0,0         ; IF AC1 IS ZERO
                        ; AC0 IS A TWO'S COMPLEMENT
        JMP 0,3         ; RETURN
	.END		;DBL.PREC.NEGATE
