
; DOUBLE PRECISION SUBTRACTION
; ****************************
; DIGITAL COMPUTER CONTROLS,INC.
; 116-0021A
;
; COMPUTES THE DIFFERENCE OF TWO DOUBLE PRECISION TWO'S
;       COMPLEMENT INTEGERS
; INPUT:        D1 IN AC0, AC1 (HIGH AND LOW)
;               ADDRESS OF D2 IN WORD AFTER JSR
; OUTPUT:       D1-D2 IN AC0, AC1 (HIGH AND LOW)
; CALLING SEQUENCE:
;       JSR     .DSUB
;       ADDRESS OF SECOND OPERAND
;       RETURN
; CAUTION:      NO CHECK IS MADE FOR OVERFLOW
; UNCHANGED:    AC2
; DESTROYED:    AC0, AC1, AC3, CARRY
	.REL	0
	.TITL	.DSUB
.DSUB:  STA 3,.BE03     ; SAVE RETURN
        STA 2,.BE02     ; *SAVE AC2
        LDA 3,0,3       ; ADDRESS OF D2
        LDA 2,0,3       ; HIGH ORDER OF D2
        LDA 3,1,3       ; LOW ORDER OF D2
        SUBZ 3,1,SNC    ; LOW ORDER SUBTRACT
        ADC 2,0,SKP     ; BORROW
        SUB 2,0         ; NO BORROW
        LDA 2,.BE02     ; *RESTORE AC2
        ISZ .BE03       ; BUMP RETURN
        JMP @.BE03      ; AND RETURN
.BE02:  0               ; *SAVE AC2
.BE03:  0               ; SAVE RETURN
	.END		;DBL.PREC.INTEG.SUBT.
