; GRAY CODE TO BINARY
; *******************
; DIGITAL COMPUTER CONTROLS, INC.
; 116-0042A-L
;
; COMPUTES THE BINARY EQUIVALENT OF A 16 BIT GRAY CODE
; WORD
; INPUT:	GRAY CODE WORD IN AC0
; OUTPUT:	BINARY EQUIVALENT IN AC0
; CALLING SEQUENCE:
;	JSR	.GRYB
; 	RETURN
; METHOD:	BIN(J) = SUM MOD 2 (N=0,J) GRAY(N)
; UNCHANGED:	AC1, AC2
; DESTROYED:	AC0, AC3, CARRY

	.REL	0
	.TITL	.GRYB

.GRYB:	STA 3,.UC03	; SAVE RETURN
	STA 1,.UC01	; *SAVE AC1
	LDA 1,.UC20	; ITERATION COUNT OF 16
	STA 1,.UC10	; SAVE IT
	SUBO 1,1	; CLEAR AC1, CARRY
.UC99:	SUBCR 3,3	; CARRY TO AC3 BIT 0
	ADDZL 3,0	; SUM MOD 2
	MOVL 1,1	; RESULT BIT TO AC1
	MOVR 1,3	; GRAY BIT TO CARRY
	DSZ .UC10	; DONE?
	JMP .UC99	; NO
	MOV 1,0		; YES, MOVE RESULT TO AC0
	LDA 1,.UC01	; *RESTORE AC1
	JMP @.UC03	; RETURN
.UC01:	0		; *SAVE AC1
.UC03:	0		; SAVE RETURN
.UC10:	0		; LOOP COUNT STORAGE
.UC20:	20		; DECIMAL 16
	.END		;GRAY TO BINARY CONV.
