
; PARITY GENERATOR
; ****************
; DIGITAL COMPUTER CONTROLS,INC.
; 116-0040A
;
; GENERATE PARITY
; INPUT:        A BINARY WORD IN AC0
; OUTPUT:       THE EVEN PARITY BIT OF THE WORD IN
;               CARRY
; CALLING SEQUENCE:
;       JSR     .PRTY
;       RETURN
; UNCHANGED:    AC0, AC1, AC2
; DESTROYED:    AC3, CARRY
	.REL	0
	.TITL	.PRTY
.PRTY:  STA 1,.UA01     ; *SAVE AC1
        STA 0,.UA00     ; *SAVE INPUT
        STA 3,.UA03     ; SAVE RETURN
        ADCZ 3,3        ; AC3 = -1, CARRY IS 0
.UA99:  MOV 0,1
        ADDC 3,1        ; AC1 = N-1
        ANDC 1,0,SZR    ; N .AND. N-1 ELIMINATES A "1"
        JMP .UA99       ; NOT DONE IF ANY 1'S LEFT
        LDA 1,.UA01     ; *RESTORE AC1
        LDA 0,.UA00     ; *RESTORE INPUT
        JMP @.UA03      ; RETURN
.UA00:  0               ; *SAVE INPUT
.UA01:  0               ; *SAVE AC1
.UA03:  0               ; SAVE AC3
	.END		;PARITY GENERATOR
