
; RANDOM NUMBER GENERATOR
; ***********************
; DIGITAL COMPUTER CONTROLS,INC.
; 116-0043A
;
; GENERATES A (PSEUDO) RANDOM SEQUENCE OF INTEGERS
; IN THE RANGE  0<= N <= 2**16-1
; INPUT:        ADDRESS OF OLD VALUE POINTED TO BY WORD
;               AFTER JSR
; OUTPUT:       16-BIT NEW RANDOM NUMBER IN AC0
;               AND IN STORAGE REPLACING OLD VALUE
; CALLING SEQUENCE:
;       JSR     .RAND
;       ADDRESS OF OLD VALUE
;       RETURN
; METHOD:       GENERATES A LINEAR CONGRUENTIAL
;               SEQUENCE OF THE FORM:
;                       X(N+1) = (X(N)*A+C)MOD 2**16
; CAUTION:      IF A K-BIT RANDOM NUMBER (AS OPPOSED
;               TO A 16- BIT NUMBER) IS NEEDED, 
;               USE THE MOST SIGNIFIGANT
;               K-BITS (THE LEAST SIGNIFIGANT K-BITS
;               ARE NOT AS RANDOM).
;               FOR EXAMPLE, TO OBTAIN RANDOM N MOD 2,
;               USE THE SIGN BIT OF THE RESULT
; UNCHANGED:    AC1, AC2
; DESTROYED:    AC0, AC3, CARRY
	.REL	0
	.TITL	.RAND
.RAND:  STA 3,.UD03     ; SAVE RETURN
        ISZ .UD03       ; BUMP PAST ADDRESS CONSTANT
        STA 1,.UD01     ; *SAVE AC1
        STA 2,.UD02     ; *SAVE AC2
        LDA 2,0,3       ; GET ADDRESS OF OLD VALUE
        LDA 0,0,2       ; OLD VALUE TO AC0
        JSR .UD50       ; N*A
        LDA 3,.UD20     ; GET INCREMENT, C
        ADD 3,0         ; (N*A+C) MOD 2**16
        STA 0,0,2       ; STORE IT
        LDA 1,.UD01     ; *RESTORE AC1
        LDA 2,.UD02     ; *RESTORE AC2
        JMP @.UD03      ; RETURN
; COMPUTE N*(2**11+2**2+1)
.UD50:  LDA 1,.UD21     ; GET COUNT, X
        STA 1,.UD10     ; FOR ITERATION
        MOVZL 0,1       ; N*2**(X+1)
        MOVZL 1,1
        DSZ .UD10
        JMP .-2
        ADD 0,1
        MOVZL 1,1
        MOVZL 1,1       ; 2**2*(N*2**(X+1)+N)
        ADD 1,0
        JMP 0,3         ; N+N*2**2+N*2**(X+3)
.UD01:  0               ; *SAVE AC1
.UD02:  0               ; *SAVE AC2
.UD03:  0               ; SAVE RETURN
.UD10:  0               ; ITERATION COUNT
.UD20:  33031           ; INCREMENT
.UD21:  10              ; ITERATION COUNT, X
	.END		;RANDOM NUMBER GENERATOR
