
; SINGLE PRECISION BCD TO BINARY
; ******************************
; DIGITAL COMPUTER CONTROLS,INC.
; 116-0029A
;
; CONVERT A NUMBER IN BCD TO BINARY
; INPUT:        A BCD INTEGER IN AC1 (MAXIMUM VALUE
;               9999 DECIMAL)
; OUTPUT:       BINARY EQUIVALENT OF BCD INPUT IN AC1
; CALLING SEQUENCE:
;       JSR     .BCDB
;       RETURN
; EXCEPTIONAL CONDITION:	IF A DIGIT >9 IS
;                       ENCOUNTERED IN THE INPUT,
;                       CARRY WILL BE SET, AC1 WILL
;                       BE UNCHANGED, AND AC0 WILL
;                       CONTAIN THE BAD DIGIT
; UNCHANGED:    AC2
; DESTROYED:    AC0, AC1, AC3, CARRY
	.REL	0
	.TITL	.BCDB
.BCDB:  STA 1,.EA01     ; SAVE INPUT
        STA 1,.EA11     ; SAVE IN CURRENT INPUT WORD
        STA 2,.EA02     ; SAVE AC2
        STA 3,.EA03     ; SAVE RETURN
        LDA 0,.EA20     ; COUNT IS 4
        STA 0,.EA12     ; SAVE IN LOOP COUNT WORD
        SUB 2,2         ; CLEAR RESULT REGISTER
.EA98:  JSR .EA50       ; GET DIGIT
        JMP .EA99       ; DIGIT IN ERROR, RETURN
        JSR .EA51       ; MULTIPLY SUM BY 10 AND ADD
                        ; DIGIT
        ISZ .EA12       ; DONE YET?
        JMP .EA98       ; NO
        MOVZ 2,1,SKP    ; YES, RESULT TO AC1, CLEAR
                        ; CARRY
.EA99:  LDA 1,.EA01     ; RESTORE INPUT IF ERROR
        LDA 2,.EA02     ; RESTORE AC2
        JMP @.EA03      ; RETURN
; GET NEXT DIGIT OF INPUT, CHECK FOR LEGAL BCD
; CALLING SEQUENCE:
;       JSR     .EA50
;       ERROR RETURN - BAD DIGIT IN AC0
;       SUCCESS RETURN - DIGIT IN AC0
.EA50:  LDA 1,.EA20     ; GET -4
        STA 1,.EA10     ; SAVE IN COUNT WORD
        LDA 1,.EA11     ; CURRENT INPUT WORD
        SUB 0,0         ; CLEAR AC0
        MOVZL 1,1
        MOVL 0,0        ; BIT TO AC0
        ISZ .EA10
        JMP .-3         ; LOOP TILL A DIGIT SHIFTED
        STA 1,.EA11     ; SAVE CURRENT INPUT WORD
        LDA 1,.EA21     ; TEST CONSTANT (10 DECIMAL)
        ADCO 0,1,SZC
        JMP 0,3         ; ERROR: >9, CARRY IS SET
        JMP 1,3         ; SUCCESS: <=9
; MULTIPLY AC2 BY 10 AND ADD AC0
.EA51:  MOVZL 2,1       ; N*2
        MOVZL 1,1       ; N*4
        ADD 2,1         ; N*5
        MOVZL 1,2       ; N*10
        ADD 0,2         ; N*10+AC0
        JMP 0,3
.EA01:  0               ; SAVE INPUT
.EA02:  0               ; SAVE AC2
.EA03:  0               ; SAVE RETURN
.EA10:  0               ; LOOP COUNT FOR SHIFT
.EA11:  0               ; CURRENT INPUT
.EA12:  0               ; LOOP COUNT FOR MULTIPLY AND
                        ; ADD
.EA20:  -4              ; COUNT
.EA21:  12              ; BCD ERROR TEST, DECIMAL 10
	.END		;SGL. BCD TO BIN.
