;SINGLE PRECISION BINARY TO BCD - I
;**********************************
;DIGITAL COMPUTER CONTROLS, INC.
;116-0030A-L
;
; CONVERT A NUMBER IN BINARY TO BCD
; INPUT:        AN UNSIGNED BINARY NUMBER IN AC1
; OUTPUT:       THE BCD EQUIVALENT IN AC1
; CALLING SEQUENCE:
;       JSR     .BBDC
;       RETURN
; EXCEPTIONAL CONDITION:        IF AC1 CONTAINS A
;                       NUMBER GREATER THAN 9999,
;                       NO CONVERSION WILL TAKE PLACE
;                       AND CARRY WILL BE SET
; UNCHANGED:    AC0, AC2
; DESTROYED:    AC1, AC3, AND CARRY
	.REL	0
	.TITL	.BBCD
.BBCD:  STA 3,.EB03     ; SAVE RETURN
        LDA 3,.EB20     ; TEST FOR >= 10000
        ADCO 1,3,SZC
        JMP @.EB03      ; ERROR, CARRY IS SET
        STA 0,.EB00     ; SAVE AC0
        STA 2,.EB02     ; SAVE AC2
        LDA 3,.EB30     ; ADDRESS OF POWER OF TEN TABLE
        SUB 0,0         ; CLEAR ACO FOR RESULT
.EB98:  LDA 2,0,3       ; GET CURRENT POWER OF TEN
        INC 3,3         ; BUMP POINTER
        MOVZL 0,0       ; SHIFT AC0 LEFT 4 PLACES
        MOVZL 0,0
        MOVZL 0,0
        MOVZL 0,0
        SUBZ 2,1,SZC    ; DOES POWER OF TEN GO IN?
        INC 0,0,SKP     ; YES, BUMP RESULT
        ADD 2,1,SKP     ; NO, RESTORE RESULT
        JMP .-3         ; LOOP TILL DOESN'T 
        MOVZR 2,2,SZR   ; DONE IF 1 IN AC2
        JMP .EB98       ; NO
.EB99:  MOVZ 0,1        ; RESULT TO AC1, CLEAR CARRY
        LDA 0,.EB00     ; RESTORE AC0
        LDA 2,.EB02     ; RESTORE AC2
        JMP @.EB03      ; RETURN
.EB00:  0               ; SAVE AC0
.EB02:  0               ; SAVE AC2
.EB03:  0               ; SAVE RETURN
        .RDX 10
.EB05:  1000            ; 10**3
        100             ; 10**2
        10              ; 10**1
        1               ; 10**0
        .RDX 8
.EB20:  23420           ; 10**4 ( > LARGEST LEGAL
                        ; INPUT)
.EB30:  .EB05           ; ADDRESS OF POWER OF TEN TABLE
	.END		;SGL.BIN TO BCD - I
