
; SINGLE PRECISION BINARY TO ASCII DECIMAL
; ****************************************
; DIGITAL COMPUTER CONTROLS,INC.
; 116-0034A
;
; CONVERTS A SINGLE PRECISION, TWO'S COMPLEMENT
;       NUMBER TO AN ASCII CHARACTER STRING
; INPUT:        N IN AC1
; OUTPUT:       ASCII CHARACTER STRING, TERMINATED BY A
;               NULL WORD
;               CHARACTERS ARE RIGHT ADJUSTED IN AC0
;               PASSED TO THE ROUTINE WHOSE ADDRESS
;               MUST BE IN LOCATION 41 OF PAGE 0
;               STRING OF FORM:
;                       +DDDDD(NULL)
;               OR      -DDDDD(NULL)
; CALLING SEQUENCE:
;       JSR     .BIND
;       RETURN
; DESTROYED:    AC1, AC3, CARRY
; UNCHANGED:    AC0, AC2
	.REL	0
	.TITL	.BIND
.BIND:  STA 3,.ED03     ; SAVE RETURN
        STA 2,.ED02     ; SAVE AC2
        STA 0,.ED00     ; SAVE AC0
        LDA 3,.ED30     ; ADDRESS OF POWER OF TEN TABLE
        STA 3,.ED10     ; INITIALIZE POINTER
        LDA 0,.ED20     ; ASSUME NEGATIVE
        MOVL# 1,1,SZC
        NEG 1,1,SKP
        LDA 0,.ED21     ; NO, IT IS POSITIVE; GET PLUS
.ED97:  STA 1,.ED11     ; SAVE N
        JSR @.ED40      ; PUT OUT SIGN OR DIGIT
        LDA 1,.ED11     ; GET CURRENT VALUE OF N
        LDA 3,@.ED10    ; GET CURRENT  POWER OF TEN
        ISZ .ED10       ; BUMP POINTER
        MOV 3,0,SNR
        JMP .ED98       ; PUT OUT NULL
        LDA 0,.ED22     ; GET ASCII "0"
.ED99:  SUBZ 3,1,SZC    ; DOES POWER OF TEN GO IN?
        INC 0,0,SKP     ; YES, BUMP RESULT DIGIT
        ADD 3,1,SKP     ; NO, RESTORE PREVIOUS VALUE
        JMP .ED99       ; CONTINUE SUBTRACTING
        JMP .ED97       ; PUT OUT DIGIT
.ED98:  JSR @.ED40      ; PUT OUT NULL WORD
        LDA 0,.ED00     ; RESTORE AC0
        LDA 2,.ED02     ; RESTORE AC2
        JMP @.ED03      ; RETURN
.ED00:  0               ; SAVE AC0
.ED02:  0               ; SAVE AC2
.ED03:  0               ; SAVE AC3
        .RDX 10
.ED05:  10000           ; POWER OF TEN TABLE
        1000            ; 10**3
        100             ; 10**2
        10              ; 10**1
        1               ; 10**0
        0               ; END OF TABLE INDICATION
        .RDX 8
.ED10:  0               ; ADDRESS OF CURRENT POWER OF
                        ; TEN ENTRY
.ED11:  0               ; RUNNING SUM WORD
.ED20:  "-              ; ASCII "-"
.ED21:  "+              ; ASCII "+"
.ED22:  60              ; ASCII "0"
.ED30:  .ED05           ; ADDRESS OF POWER OF TEN TABLE
.ED40=41                ; PAGE ZERO PUT CHARACTER
                        ; ROUTINE ADDRESS
	.END		;SGL. BIN TO ASCII DEC.
