
; SINGLE PRECISION --ASCII DECIMAL TO BINARY
; ******************************************
; DIGITAL COMPUTER CONTROLS,INC.
; 116-0031A
;
; CONVERTS AN ASCII DECIMAL CHARACTER STRING TO A
;       TWO'S COMPLEMENT, FIXED POINT, BINARY NUMBER
; INPUT:        CALLS A GET CHARACTER ROUTINE WHOSE
;               ADDRESS MUST BE STORED IN LOCATION 40 
;               OF PAGE 0
;               CHARACTERS MUST BE RETURNED RIGHT
;               ADJUSTED IN AC0 WITH BIT 8=0
;               + IS OPTIONAL FOR POSITIVE NUMBERS
;               - MUST BE GIVEN FOR NEGATIVE NUMBERS
;               INPUT OF FORM:
;                       SDD...D(BREAK)
;               S IS THE SIGN, D A DECIMAL DIGIT
;               THE BREAK CHARACTER IS ANY CHARACTER
;                OTHER THAN A DIGIT.
; OUTPUT:       AC0 CONTAINS THE BREAK CHARACTER
;               AC1 CONTAINS THE BINARY INTEGER
; CALLING SEQUENCE:
;       JSR     .DBIN
;       RETURN
; IF AN INDICATION IS DESIRED TO SIGNAL CHARACTERS ARE
; REQUESTED, CALLING SEQUENCE IS:
;       JSR     .DBNI
;       RETURN
; AN ASCII "S" FOLLOWED BY A NULL WORD
; WILL BE TRANSMITTED VIA AC0 TO A PUT CHARACTER
; ROUTINE WHOSE ADDRESS MUST BE IN LOCATION 41 OF
; PAGE 0
; CAUTION:      THE ABSOLUTE VALUE OF THE RESULT IS
;               N MOD 2**15.
;               FOR EXAMPLE, +96741 CONVERTS TO +31205
;               -2**15 CONVERTS TO 0
; DESTROYED:    AC0,AC1
; UNCHANGED:    AC2,AC3
	.REL	0
	.TITL	.DBNI
.DBNI:  STA 3,.EC03     ; SAVE RETURN
        STA 2,.EC02     ; SAVE AC2
        LDA 0,.EC24     ; GET "S"
        JSR @.EC41      ; SEND "S"
        SUB 0,0
        JSR @.EC41      ; SEND NULL
        JMP .+3
.DBIN:  STA 3,.EC03     ; SAVE AC3
        STA 2,.EC02     ; SAVE AC2
        SUB 0,0
        STA 0,.EC10     ; CLEA SIGN WORD
        STA 0,.EC11     ; CLEAR SUM WORD
        JSR @.EC40      ; GET A CHARACTER
        LDA 1,.EC20     ; TEST FOR "+"
        SUB 0,1,SNR
        JMP .EC97       ; YES
        LDA 1,.EC21     ; NO, TEST FOR "-"
        SUB 0,1,SZR
        JMP .EC96       ; NO EXPLICIT SIGN
        ISZ .EC10       ; SET FLAG WORD FOR NEGATIVE
                        ; NUMBER
.EC97:  JSR @.EC40      ; GET ANOTHER CHARACTER
.EC96:  LDA 1,.EC22     ; ASCII "0"
        LDA 2,.EC23     ; ASCII "9"
        ADCZ# 2,0,SNC   ; SKIP IF > 9
        ADCZ# 0,1,SZC   ; SKIP IF >= 0
        JMP .EC95       ; NOT A DIGIT, THERFORE A BREAK
                        ; CHARACTER
        SUB 1,0         ; REDUCE DIGIT TO 0-9 BINARY
                        ; RANGE
        LDA 1,.EC11     ; SUM WORD
        JSR .EC50       ; MULTIPLY BY 10 AND ADD
        STA 1,.EC11     ; SAVE SUM
        JMP .EC97       ; GET NEXT CHARACTER
        
.EC95:  LDA 1,.EC11     ; RESULT TO AC1
        MOVZL 1,1
        DSZ .EC10       ; TEST SIGN
        MOVZR 1,1,SKP   ; POSITIVE
        NEGOR 1,1       ; NEGATIVE
        LDA 2,.EC02     ; RESTORE AC2
        JMP @.EC03
; ROUTINE TO MULTIPLY AC1 BY 10 AND ADD AC0
.EC50:  MOVZL 1,2       ; N*2
        MOVZL 2,2       ; N*4
        ADD 2,1         ; N*5
        MOVZL 1,1       ; N*5*2 = N*10
        ADD 0,1         ; ADD AC0
        JMP 0,3         ; SUCCESS RETURN
.EC02:  0               ; SAVE AC2
.EC03:  0               ; SAVE AC3
.EC10:  0               ; FLAG WORD FOR SIGN OF RESULT
.EC11:  0               ; RUNNING SUM WORD
.EC20:  "+              ; ASCII "+"
.EC21:  "-              ; ASCII "-"
.EC22:  "0              ; ASCII "0"
.EC23:  "9              ; ASCII "9"
.EC24:  "S              ; ASCII "S" FOR INDICATION
                        ; ENTRY
.EC40=40                ; ADDRESS OF GET CHARACTER
                        ; ROUTINE
.EC41=41                ; ADDRESS OF PUT CHARACTER
                        ; ROUTINE
	.END		;SGL ASCII DEC TO BIN
