;
; SINGLE PRECISION OCTAL TO BINARY CONVERSION
;********************************************
; DIGITAL COMPUTER CONTROLS,INC.
; 116-0035A
;
; CONVERT AN ASCII OCTAL CHARACTER STRING TO A BINARY
; NUMBER
; INPUT:        CALLS A GET CHARACTER ROUTINE WHOSE
;               ADDRESS MUST BE STORED
;               IN LOCATION 40 OF PAGE 0. 
;               CHARACTERS MUST BE RETURNED,
;               RIGHT ADJUSTED IN AC0 WITH BIT 8=0
;               INPUT OF FORM:
;                       OO...O(BREAK)
;              WHERE "O" REPRESENTS AN OCTAL DIGIT AND
;               BREAK IS ANY OTHER CHARACTER
; OUTPUT:       AC0 CONTAINS THE BREAK CHARACTER
;               AC1 CONTAINS THE BINARY NUMBER (MOD
;               200000 OCTAL)
; CALLING SEQUENCE:
;       JSR     .OBIN
;       RETURN
; IF AN INDICATION IS DESIRED TO SIGNAL CHARACTERS ARE
; REQUESTED, CALLING SEQUENCE:
;       JSR     .OBNI
;       RETURN
; AN ASCII "O" FOLLOWED BY A NULL CHARACTER 
; WILL BE TRANSMITTED VIA AC0
; TO USER PUT CHARACTER ROUTINE WHOSE
; ADDRESS MUST BE STORED IN LOCATION 41 OF PAGE 0
; CAUTION:      RESULT IS N MOD 200000 (OCTAL)
;               E.G. 576452* CONVERTS TO 176452
; DESTROYED:    AC0, AC1, AC3, CARRY
; UNCHANGED:    AC2
	.REL	0
	.TITL	.OBIN
	.ENT	.OBNI
.OBNI:  STA 3,.EE03     ; SAVE RETURN
        STA 2,.EE02     ; SAVE AC2
        LDA 0,.EE22
        JSR @.EE41      ;SEND "O"
        SUB 0,0
        JSR @,.EE41     ; SEND NULL
        JMP .+3
.OBIN:  STA 3,.EE03     ; SAVE RETURN
        STA 2,.EE02     ; SAVE AC2
        SUB 1,1         ; CLEAR RESULT WORD
        STA 1,.EE10
	.FORM

.EE98:  JSR @.EE40      ; GET A DIGIT
        LDA 2,.EE20     ; OCTAL 60
        LDA 3,.EE21     ; OCTAL 67
        ADCZ# 3,0,SNC   ; TEST FOR 60 <=N<= 67
        ADCZ# 0,2,SZC
        JMP .EE99       ; NO - MUST BE BREAK CHARACTER
        SUB 2,0         ; PUT N IN RANGE 0-7
        LDA 1,.EE10
        MOVZL 1,1       ; SHIFT SUM
        MOVZL 1,1
        MOVZL 1,1
        ADD 0,1
        STA 1,.EE10
        JMP .EE98       ; LOOP TILL BREAK RECEIVED
.EE99:  LDA 2,.EE02     ; RESTORE AC2
        LDA 1,.EE10     ; ANSWER TO AC1
        JMP @.EE03      ; AND RETURN
.EE02:  0               ; SAVE AC2
.EE03:  0               ; SAVE RETURN
.EE10:  0               ; STORAGE FOR RESULTS
.EE20:  60              ; ASCII "0"
.EE21:  67              ; ASCII "7"
.EE22:  "O              ; ASCII "O"
.EE40=40                ; PAGE 0 ADDRESS OF GET A
                        ; CHARRACTER ROUTINE
.EE41=41                ; PAGE 0 ADDRESS OF PUT A
                        ; CHARACTER ROUTINE
	.END		;SGL. ASCII OCTAL TO BIN.
