
; UNSIGNED DIVIDE
; ***************
; DIGITAL COMPUTER CONTROLS,INC.
; 116-0026A
;
; DIVIDES TWO UNSIGNED NUMBERS
; INPUT:        DIVIDEND IN AC0, AC1 ; HIGH ORDER, LOW
;               ORDER
;               DIVISOR IN AC2
; OUTPUT:       REMAINDER IN AC0
;               QUOTIENT IN AC1
; CALLING SEQUENCE
;       JSR     .DIVU
;       RETURN
; FOR INTEGER DIVIDE (SINGLE PRECISION DIVIDEND)
;       JSR     .DIVI
;       RETURN
;  ERROR CONDITION:     AC0 >= AC2 ( INPLIES RESULT >
;                       2**16-1)
;                       SETS CARRY AND RETURNS
;                       OTHERWISE CARRY IS 0
; DESTROYED:    AC0, AC1 (AC1 UNCHANGED IF DIVIDE
;               ERROR), AC3, CARRY
; UNCHANGED:    AC2
	.REL	0
	.TITL	.DIVU
	.ENT	.DIVI
.DIVI:  SUB 0,0         ; INTEGER DIVIDE, CLEAR AC0
.DIVU:  STA 3,.CC03     ; SAVE AC3
        SUBZ# 2,0,SZC   ; TEST FOR OVERFLOW
        JMP .CC99       ; SET CARRY AND RETURN
        LDA 3,.CC20     ; 16 ITERATIONS
        MOVZL 1,1       ; SHIFT LOW DIVIDEND
.CC98:  MOVL 0,0        ; SHIFT HIGH DIVIDEND
        SUB# 2,0,SZC    ; DOES DIVISOR GO IN?
        SUB 2,0         ; YES
        MOVL 1,1        ; SHIFT LOW DIVIDEND
        INC 3,3,SZR     ; CHECK COUNT
        JMP .CC98       ; NOT DONE
        SUBO 3,3,SKP    ; DONE , CLEAR CARRY
.CC99:  SUBZ 3,3        ; SET CARRY
        JMP @.CC03      ; RETURN

.CC03:  0               ; SAVE AC3
.CC20:  -20             ; - 16 DECIMAL
	.END		;UNSIGNED DIVIDE
