
; UNSIGNED MULTIPLY
; *****************
; DIGITAL COMPUTER CONTROLS, INC.
; 116-0025A-L
;
; UNSIGNED MULTIPLY
; MULTIPLIES TWO UNSIGNED, FIXED POINT, SINGLE
;	PRECISION NUMBERS
; INPUT:	N1 IN AC1, N2 IN AC2
; OUTPUT:	N1*N2, HIGH ORDER IN AC0, LOW ORDER IN
;		AC1
; CALLING SEQUENCE:
;	JSR	.MPYU
;	RETURN
; INPUT:	N0 IN AC0, N1 IN AC1, N2 IN AC2
; OUTPUT:	N0 + N1*N2, HIGH ORDER IN AC0, LOW
;		ORDER IN AC1
; CALLING SEQUENCE
;	JSR	.MPYA
;	RETURN
; DESTROYED:	AC0, AC1, AC3
; UNCHANGED:	AC2, CARRY
;
	.REL	0
	.TITL	.MPYU
	.ENT	.MPYA
.MPYU:	SUBC 0,0	; CLEAR ACO, DON'T DISTURB
			; CARRY
.MPYA:	STA 3,.CB03	; SAVE AC3
	LDA 3,.CB20	; 16 TIMES THRU LOOP
.CB99:	MOVR 1,1,SNC	; CHECK NEXT MULTIPLIER BIT
	MOVR 0,0,SKP	; 0, JUST SHIFT
	ADDZR 2,0	; 1, ADD MULTIPLICAND AND SHIFT
	INC 3,3,SZR	; CHECK FOR 16TH TIME THRU
	JMP .CB99	; NO, CONTINUE
	MOVCR 1,1	; YES, SHIFT LAST LOW BIT
			; (NOTE IT WAS COMPLEMENTED BY
			; FINAL INC)
	JMP @.CB03	; RETURN
.CB03:	0		; RETURN ADDRESS
.CB20:	-20		; -16 DECIMAL
	.END		;UNSIGNED MULTIPLY
